<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Modulo extends Model 
{

    protected $table = 'modulos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'route');
    protected $visible = array('name', 'route');

    public function tipo_solicitudes()
    {
        return $this->hasMany('App\Models\TipoSolicitud', 'modulo_id');
    }

}